# Change submenu appearance - remove dotted lines and lighten colors
root.option_add('*Menu.borderWidth', 0)  # Remove border
root.option_add('*Menu.activeBorderWidth', 0)  # Remove active border
root.option_add('*Menu.relief', 'flat')  # Remove 3D effect
root.option_add('*Menu.activeBackground', '#F0F0F0')  # Light gray active background
root.option_add('*Menu.background', '#FAFAFA')  # Very light background
root.option_add('*Menu.foreground', '#505050')  # Softer text color
root.option_add('*Menu.activeForgeground', '#303030')  # Darker text when active

# Apply style sheet to lighten menu colors and remove dotted lines
app.setStyleSheet("""
    QMenu {
        background-color: #FAFAFA;
        color: #505050;
        border: none;
    }
    QMenu::item {
        background-color: transparent;
        padding: 5px 20px;
    }
    QMenu::item:selected {
        background-color: #F0F0F0;
        color: #303030;
    }
    QMenu::separator {
        height: 1px;
        background-color: #E0E0E0;
        margin: 5px 0px;
    }
""") 