import paramiko
import socket
from PyQt5.QtCore import QObject, pyqtSignal

class ProxyManager(QObject):
    status_changed = pyqtSignal(str)  # 状态变化信号

    def __init__(self):
        super().__init__()
        self.proxy_client = None
        self.transport = None
        self.is_connected = False

    def connect(self, ip, port, username, password):
        """连接到代理服务器"""
        try:
            # 先进行DNS解析检查
            try:
                socket.gethostbyname(ip)
            except socket.gaierror:
                raise Exception("无法解析代理服务器地址，请检查IP是否正确")

            self.proxy_client = paramiko.SSHClient()
            self.proxy_client.set_missing_host_key_policy(paramiko.AutoAddPolicy())

            # 建立连接
            self.proxy_client.connect(
                hostname=ip,
                port=int(port),
                username=username,
                password=password,
                timeout=10,
                allow_agent=False,
                look_for_keys=False
            )

            self.transport = self.proxy_client.get_transport()
            self.is_connected = True
            self.status_changed.emit("已连接到代理服务器")

        except Exception as e:
            self.status_changed.emit(f"代理连接失败: {str(e)}")
            raise e

    def create_tunnel(self, target_host, target_port):
        """创建到目标服务器的隧道"""
        try:
            if not self.transport:
                raise Exception("代理连接失败")

            channel = self.transport.open_channel(
                'direct-tcpip',
                (target_host, target_port),
                ('', 0)
            )

            if not channel:
                raise Exception("无法创建通道")

            return channel
            
        except Exception as e:
            self.status_changed.emit(f'创建通道失败: {str(e)}')
            raise

    def close(self):
        """关闭代理连接"""
        if self.proxy_client:
            try:
                self.proxy_client.close()
                self.proxy_client = None
                self.transport = None
                self.is_connected = False
                self.status_changed.emit('代理连接已关闭')
            except:
                pass