from PyQt5.QtWidgets import (QDialog, QVBoxLayout, QLabel, QPushButton, 
                            QHBoxLayout, QRadioButton, QButtonGroup)
from PyQt5.QtCore import Qt, pyqtSignal

class ThemeDialogSimple(QDialog):
    """简化版主题选择对话框"""
    themeSelected = pyqtSignal(str)
    
    def __init__(self, parent=None, current_theme="light"):
        super().__init__(parent)
        self.setWindowTitle("选择主题")
        self.setMinimumWidth(300)
        
        self.current_theme = current_theme
        self.setWindowFlags(self.windowFlags() & ~Qt.WindowContextHelpButtonHint)
        
        self.init_ui()
    
    def init_ui(self):
        layout = QVBoxLayout(self)
        
        # 标题
        title = QLabel("请选择应用主题", self)
        title.setStyleSheet("font-size: 16px; font-weight: bold;")
        layout.addWidget(title)
        
        # 创建主题选择按钮组
        self.theme_group = QButtonGroup(self)
        
        # 浅色主题选项
        light_option = QRadioButton("浅色主题", self)
        light_option.setStyleSheet("""
            QRadioButton {
                font-size: 14px;
                padding: 8px;
            }
            QRadioButton::indicator {
                width: 16px;
                height: 16px;
            }
        """)
        self.theme_group.addButton(light_option, 0)
        layout.addWidget(light_option)
        
        # 浅色主题示例
        light_example = QLabel(self)
        light_example.setStyleSheet("""
            background-color: #f5f5f5;
            color: #333333;
            border: 1px solid #cccccc;
            border-radius: 4px;
            padding: 10px;
        """)
        light_example.setText("示例文本 - 浅色主题")
        light_example.setMinimumHeight(60)
        light_example.setAlignment(Qt.AlignCenter)
        layout.addWidget(light_example)
        
        # 深色主题选项
        dark_option = QRadioButton("深色主题", self)
        dark_option.setStyleSheet("""
            QRadioButton {
                font-size: 14px;
                padding: 8px;
            }
            QRadioButton::indicator {
                width: 16px;
                height: 16px;
            }
        """)
        self.theme_group.addButton(dark_option, 1)
        layout.addWidget(dark_option)
        
        # 深色主题示例
        dark_example = QLabel(self)
        dark_example.setStyleSheet("""
            background-color: #333333;
            color: #f0f0f0;
            border: 1px solid #555555;
            border-radius: 4px;
            padding: 10px;
        """)
        dark_example.setText("示例文本 - 深色主题")
        dark_example.setMinimumHeight(60)
        dark_example.setAlignment(Qt.AlignCenter)
        layout.addWidget(dark_example)
        
        # 按钮区域
        button_layout = QHBoxLayout()
        button_layout.addStretch()
        
        # 取消按钮
        cancel_btn = QPushButton("取消", self)
        cancel_btn.clicked.connect(self.reject)
        button_layout.addWidget(cancel_btn)
        
        # 确定按钮
        ok_btn = QPushButton("确定", self)
        ok_btn.clicked.connect(self.apply_theme)
        button_layout.addWidget(ok_btn)
        
        layout.addLayout(button_layout)
        
        # 设置当前主题
        if self.current_theme == "dark":
            dark_option.setChecked(True)
        else:
            light_option.setChecked(True)
    
    def apply_theme(self):
        """应用选中的主题"""
        selected = self.theme_group.checkedId()
        theme = "dark" if selected == 1 else "light"
        self.themeSelected.emit(theme)
        self.accept() 