from PyQt5.QtWidgets import QApplication

class ThemeManager:
    @staticmethod
    def apply_light_theme(app):
        """应用浅色主题"""
        app.setStyleSheet("""
            /* 全局样式 - 浅色主题 */
            QWidget {
                background-color: #f5f5f5;
                color: #333333;
                font-family: 'Arial', 'Helvetica';
            }
            
            /* 表格样式 */
            QTableView, QTableWidget {
                background-color: white;
                color: #333333;
                alternate-background-color: #f0f0f0;
                gridline-color: #d0d0d0;
                selection-background-color: #0078d7;
                selection-color: white;
            }
            
            QTableView QHeaderView::section, QTableWidget QHeaderView::section {
                background-color: #e0e0e0;
                color: #333333;
                padding: 5px;
                border: 1px solid #d0d0d0;
            }
            
            /* 表单样式 */
            QLineEdit, QTextEdit, QComboBox, QSpinBox {
                background-color: white;
                color: #333333;
                border: 1px solid #aaaaaa;
                padding: 5px;
                selection-background-color: #0078d7;
                selection-color: white;
            }
            
            /* 普通按钮样式 */
            QPushButton {
                background-color: #0078d7;
                color: white;
                border: none;
                padding: 8px 16px;
                font-weight: bold;
                border-radius: 4px;
            }
            
            QPushButton:hover {
                background-color: #0063b1;
            }
            
            QPushButton:pressed {
                background-color: #00478f;
            }
            
            /* 取消按钮 */
            QPushButton#cancelButton {
                background-color: #f0f0f0;
                color: #333333;
                border: 1px solid #cccccc;
            }
            
            QPushButton#cancelButton:hover {
                background-color: #e0e0e0;
            }
            
            /* 删除按钮 */
            QPushButton[text="删除"], QPushButton[text*="删除"], QPushButton#deleteButton {
                background-color: #e74c3c;
                color: white;
                border: none;
                padding: 8px 16px;
                font-weight: bold;
            }
            
            QPushButton[text="删除"]:hover, QPushButton[text*="删除"]:hover, QPushButton#deleteButton:hover {
                background-color: #c0392b;
            }
            
            /* 连接按钮 */
            QPushButton[text="连接"], QPushButton#connectButton {
                background-color: #2ecc71;
                color: white;
            }
            
            QPushButton[text="连接"]:hover, QPushButton#connectButton:hover {
                background-color: #27ae60;
            }
            
            /* 表格中的链接文本 */
            QTableWidget QLabel[class="link-label"], QTableView QLabel[class="link-label"] {
                color: #3498db;
            }
            
            /* 对话框 */
            QDialog {
                background-color: #f5f5f5;
            }
            
            QDialog QLabel, QMessageBox QLabel {
                color: #333333;
            }
            
            /* 滚动条样式 */
            QScrollBar:vertical {
                border: none;
                background: #f0f0f0;
                width: 10px;
                margin: 0px;
            }
            
            QScrollBar::handle:vertical {
                background: #c0c0c0;
                min-height: 30px;
                border-radius: 5px;
            }
            
            QScrollBar::handle:vertical:hover {
                background: #a0a0a0;
            }
            
            /* 状态栏 */
            QStatusBar {
                background-color: #e0e0e0;
                color: #333333;
            }
            
            /* 菜单栏 */
            QMenuBar {
                background-color: #f0f0f0;
                color: #333333;
            }
            
            QMenuBar::item:selected {
                background-color: #0078d7;
                color: white;
            }
            
            /* 菜单 */
            QMenu {
                background-color: white;
                color: #333333;
                border: 1px solid #d0d0d0;
            }
            
            QMenu::item:selected {
                background-color: #0078d7;
                color: white;
            }
        """)

    @staticmethod
    def apply_dark_theme(app):
        """应用深色主题"""
        app.setStyleSheet("""
            /* 全局样式 - 深色主题 */
            QWidget {
                background-color: #2d2d2d;
                color: #f0f0f0;
                font-family: 'Arial', 'Helvetica';
            }
            
            /* 表格样式 */
            QTableView, QTableWidget {
                background-color: #333333;
                color: #f0f0f0;
                alternate-background-color: #3a3a3a;
                gridline-color: #505050;
                selection-background-color: #0078d7;
                selection-color: white;
            }
            
            QTableView QHeaderView::section, QTableWidget QHeaderView::section {
                background-color: #424242;
                color: #f0f0f0;
                padding: 5px;
                border: 1px solid #505050;
            }
            
            /* 表单样式 */
            QLineEdit, QTextEdit, QComboBox, QSpinBox {
                background-color: #424242;
                color: #f0f0f0;
                border: 1px solid #555555;
                padding: 5px;
                selection-background-color: #0078d7;
                selection-color: white;
            }
            
            /* 普通按钮样式 */
            QPushButton {
                background-color: #0078d7;
                color: white;
                border: none;
                padding: 8px 16px;
                font-weight: bold;
                border-radius: 4px;
            }
            
            QPushButton:hover {
                background-color: #0063b1;
            }
            
            QPushButton:pressed {
                background-color: #00478f;
            }
            
            /* 取消按钮 */
            QPushButton#cancelButton {
                background-color: #505050;
                color: white;
                border: 1px solid #666666;
            }
            
            QPushButton#cancelButton:hover {
                background-color: #606060;
            }
            
            /* 删除按钮 */
            QPushButton[text="删除"], QPushButton[text*="删除"], QPushButton#deleteButton {
                background-color: #c0392b;
                color: white;
                border: none;
                padding: 8px 16px;
                font-weight: bold;
            }
            
            QPushButton[text="删除"]:hover, QPushButton[text*="删除"]:hover, QPushButton#deleteButton:hover {
                background-color: #e74c3c;
            }
            
            /* 连接按钮 */
            QPushButton[text="连接"], QPushButton#connectButton {
                background-color: #27ae60;
                color: white;
            }
            
            QPushButton[text="连接"]:hover, QPushButton#connectButton:hover {
                background-color: #2ecc71;
            }
            
            /* 表格中的链接文本 */
            QTableWidget QLabel[class="link-label"], QTableView QLabel[class="link-label"] {
                color: #3498db;
            }
            
            /* 对话框 */
            QDialog {
                background-color: #333333;
            }
            
            QDialog QLabel, QMessageBox QLabel {
                color: #f0f0f0;
            }
            
            /* 滚动条样式 */
            QScrollBar:vertical {
                border: none;
                background: #383838;
                width: 10px;
                margin: 0px;
            }
            
            QScrollBar::handle:vertical {
                background: #606060;
                min-height: 30px;
                border-radius: 5px;
            }
            
            QScrollBar::handle:vertical:hover {
                background: #808080;
            }
            
            /* 状态栏 */
            QStatusBar {
                background-color: #424242;
                color: #f0f0f0;
            }
            
            /* 菜单栏 */
            QMenuBar {
                background-color: #333333;
                color: #f0f0f0;
            }
            
            QMenuBar::item:selected {
                background-color: #0078d7;
                color: white;
            }
            
            /* 菜单 */
            QMenu {
                background-color: #424242;
                color: #f0f0f0;
                border: 1px solid #505050;
            }
            
            QMenu::item:selected {
                background-color: #0078d7;
                color: white;
            }
        """) 